/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
int IrcStringGetWord(char* dst, const char* src, int maxLen, const char** ppEnd);
const char* IrcStringSkipSpaces(const char* psz);

bool IsChannelString(const std::string& channel);
std::string GetPrefixNick(const std::string& prefix);
std::string GetPrefixHost(const std::string& prefix);
std::string GetPrefixIdent(const std::string& prefix);
std::string StripNickModes(const std::string& nick, const std::string& modeChars);
std::string StripNickModesAndInvalidChars(const std::string& nick, const std::string& modeChars);
bool NickHasMode(const std::string& nick, char mode);

bool IsTwitchChatUrl(const std::string& url);

bool IsSimpleWordCharacter(char ch);
std::string GetWord(const std::string& str, uint32_t start, bool getRest, uint32_t& end);
std::string ReplaceSubstring(const std::string& source, const std::string& target, const std::string& with);

/**
 * Parses an IRC escaped string into a normal string, according to the IRC spec here:
 * http://ircv3.net/specs/core/message-tags-3.2.html
 */
std::string UnescapeMessageTag(const std::string& escapedMessageTag);

bool Compare(const std::string& one, const std::string& two, bool caseSensitive);

inline bool IsSlashCommandMessage(const std::string& message) {
  return message.size() > 0 && message[0] == '/';
}
}  // namespace chat
}  // namespace ttv
