/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/isquadnotifications.h"
#include "twitchsdk/chat/isquadnotificationslistener.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"
#include "twitchsdk/core/user/user.h"

namespace ttv {
namespace chat {
class SquadNotifications;
}
}  // namespace ttv

class ttv::chat::SquadNotifications : public ISquadNotifications, public PubSubComponent<ISquadNotificationsListener> {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  SquadNotifications(const std::shared_ptr<User>& user, const std::string& squadId);

  // Component Overrides
  static std::string GetComponentName() { return "ttv::chat::SquadNotifications"; }
  virtual std::string GetLoggerName() const override;

  // ISquadNotifications implementation
  virtual TTV_ErrorCode Dispose() override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const ttv::json::Value& jVal) override;

 private:
  std::string mPubSubTopic;
};
