/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/isubscriptionsnotifications.h"
#include "twitchsdk/chat/isubscriptionsnotificationslistener.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"
#include "twitchsdk/core/user/user.h"

namespace ttv {
namespace chat {
class SubscriptionsNotifications;
}
}  // namespace ttv

class ttv::chat::SubscriptionsNotifications : public ISubscriptionsNotifications,
                                              public PubSubComponent<ISubscriptionsNotificationsListener> {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  SubscriptionsNotifications(const std::shared_ptr<User>& user);

  // Component Overrides
  static std::string GetComponentName() { return "ttv::chat::SubscriptionsNotifications"; }
  virtual std::string GetLoggerName() const override;

  // ISubscriptionsNotifications implementation
  virtual TTV_ErrorCode Dispose() override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const ttv::json::Value& jVal) override;

 private:
  std::string mPubSubTopic;
};
