/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatAddNewRoomTask;
}
}  // namespace ttv

class ttv::chat::ChatAddNewRoomTask : public ttv::HttpTask {
 public:
  using Callback =
    std::function<void(ChatAddNewRoomTask* source, TTV_ErrorCode ec, CreateRoomError&& error, ChatRoomInfo&& info)>;

  ChatAddNewRoomTask(const std::string& roomName, const std::string& topic, RoomRolePermissions roomPermissions,
    const std::string& authToken, Callback&& callback);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatAddNewRoomTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  ChatRoomInfo mResult;
  CreateRoomError mError;
  Callback mCallback;
  std::string mRoomName;
  std::string mRoomTopic;
  RoomRolePermissions mRoomPermissions;
};
