/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#ifndef TTVSDK_CHATAPITASK_H
#define TTVSDK_CHATAPITASK_H

#include "twitchsdk/core/httprequest.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatApiTask;
}
}  // namespace ttv

class ttv::chat::ChatApiTask : public ttv::Task {
 public:
  struct HttpRequestInfo {
    HttpRequestInfo();

    std::string url;
    std::vector<HttpParam> requestHeaders;
    std::string requestBody;
    HttpRequestType httpReqType;
    uint timeOutInSecs;
    uint numRetries;
  };

 public:
  ChatApiTask(TaskCallback callback, void* userData, const char* authToken)
      : Task(callback, userData), mTaskStatus(TTV_EC_UNKNOWN_ERROR) {
    if (authToken) {
      mAuthToken = authToken;
    }
  }

  virtual ~ChatApiTask();

  virtual void Run();
  virtual void OnComplete();

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) = 0;
  virtual void ResponseCallback(uint statusCode, const std::vector<char>& response, void* userData);
  virtual bool ProcessHeaders(const std::map<std::string, std::string>& headers);
  virtual void ProcessResponse(const std::vector<char>& response) = 0;

 private:
  bool HeadersCallback(uint statusCode, const std::map<std::string, std::string>& headers, void* userData);

 protected:
  TTV_ErrorCode mTaskStatus;

 private:
  std::string mAuthToken;
};

#endif  // TTVSDK_CHATAPITASK_H
