/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatBanUserTask;
}
}  // namespace ttv

class ttv::chat::ChatBanUserTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatBanUserTask* source, TTV_ErrorCode ec, BanUserError&& error)>;

  ChatBanUserTask(
    ChannelId channelId, const std::string& bannedUserName, const std::string& authToken, Callback&& callback);
  void SetTimeout(uint32_t durationSeconds);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatBanUserTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  Callback mCallback;
  BanUserError mError;
  std::string mBannedUserName;
  ChannelId mChannelId;
  uint32_t mDurationSeconds;
};
