/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <map>

namespace ttv {
namespace chat {
class ChatChangeUserBlockTask;
}
}  // namespace ttv

class ttv::chat::ChatChangeUserBlockTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(
    ChatChangeUserBlockTask* source, TTV_ErrorCode result, UserId userId, UserId blockUserId, bool block)>;

 public:
  ChatChangeUserBlockTask(UserId userId, const std::string& authToken, UserId blockUserId, bool block,
    const std::string& reason, Callback callback);

  void SetWhisper(bool whisper) { mWhisper = whisper; }

 protected:
  virtual const char* GetTaskName() const override { return "ChatChangeUserBlockTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void OnComplete() override;

 private:
  Callback mCallback;
  std::string mReason;
  UserId mUserId;
  UserId mBlockUserId;
  bool mBlock;
  bool mWhisper;
};
