/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <map>

namespace ttv {
namespace chat {
class ChatChannelUsersTask;
}
}  // namespace ttv

class ttv::chat::ChatChannelUsersTask : public ttv::HttpTask {
 public:
  struct Result {
    Result();

    UserList users;
    uint32_t cacheControlMaxAgeSeconds;
  };

  using Callback = std::function<void(ChatChannelUsersTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

  ChatChannelUsersTask(const std::string& channelName, Callback callback);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatChannelUsersTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual bool ProcessHeaders(uint statusCode, const std::map<std::string, std::string>& headers) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  void ParseUserList(ttv::json::Value jGroup, std::vector<std::string>& users);

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  std::string mChannelName;
};
