/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatDeleteCommentTask;
}
}  // namespace ttv

class ttv::chat::ChatDeleteCommentTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatDeleteCommentTask* source, TTV_ErrorCode ec)>;

 public:
  ChatDeleteCommentTask(const std::string& commentId, const std::string& authToken, Callback&& callback);

 protected:
  virtual const char* GetTaskName() const override { return "ChatDeleteCommentTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void OnComplete() override;

 private:
  std::string mCommentId;
  Callback mCallback;
};
