/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <map>

namespace ttv {
namespace chat {
class ChatGetBadgesTask;
}
}  // namespace ttv

class ttv::chat::ChatGetBadgesTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatGetBadgesTask* source, TTV_ErrorCode ec, BadgeSet&& badges)>;

 public:
  ChatGetBadgesTask(ChannelId channelId, Callback&& callback);

  void SetLanguage(const std::string& language);

  virtual void OnComplete() override;

 protected:
  bool ParseBadgeVersion(const ttv::json::ValueConstIterator& jIter, BadgeVersion& version);
  bool ParseBadge(const ttv::json::ValueConstIterator& jIter, Badge& badgeSet);

  virtual const char* GetTaskName() const override { return "ChatGetBadgesTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  BadgeSet mResult;
  Callback mCallback;
  ChannelId mChannelId;
  std::string mLanguage;
};
