/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/internal/task/chatapitask.h"
#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace chat {
class ChatGetBitsConfigTask;
}
}  // namespace ttv

class ttv::chat::ChatGetBitsConfigTask : public ttv::HttpTask {
 public:
  struct Result {
    std::vector<BitsConfiguration::Cheermote> cheermotes;  //!< Sorted by increasing minBits.
  };

  using Callback = std::function<void(ChatGetBitsConfigTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

 public:
  ChatGetBitsConfigTask(ChannelId channelId, Callback callback);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatGetBitsConfigTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  ChannelId mChannelId;  // A ChannelId of 0 implies a global bits configuration
};
