/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <map>

namespace ttv {
namespace chat {
class ChatGetBlockListTask;
}
}  // namespace ttv

class ttv::chat::ChatGetBlockListTask : public ttv::HttpTask {
 public:
  struct Result {
    std::vector<UserInfo> users;
    bool valid;
  };

  using Callback = std::function<void(ChatGetBlockListTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

  ChatGetBlockListTask(UserId userId, const std::string& authToken, std::shared_ptr<Result> result, Callback callback);

 protected:
  virtual const char* GetTaskName() const override { return "ChatGetBlockListTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  Callback mCallback;
  std::shared_ptr<Result> mResult;
  UserId mUserId;
};
