/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatGetCommentTask;
}
}  // namespace ttv

class ttv::chat::ChatGetCommentTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatGetCommentTask* source, TTV_ErrorCode ec, ChatComment&& result)>;

  ChatGetCommentTask(const std::string& commentId, const TokenizationOptions& options,
    const std::shared_ptr<BitsConfiguration>& config, Callback&& callback);
  void SetLocalUserNames(const std::vector<std::string>& localUserNames) { mLocalUserNames = localUserNames; }

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatGetCommentTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  std::vector<std::string> mLocalUserNames;
  std::shared_ptr<BitsConfiguration> mBitsConfiguration;
  ChatComment mResult;
  TokenizationOptions mTokenizationOptions;
  std::string mCommentId;
  Callback mCallback;
};
