/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatGetEmoticonsTask;
}
}  // namespace ttv

/**
 * Fetches the emoticons in each emoticon set.
 */
class ttv::chat::ChatGetEmoticonsTask : public ttv::HttpTask {
 public:
  using Callback =
    std::function<void(ChatGetEmoticonsTask* source, TTV_ErrorCode ec, std::vector<EmoticonSet>&& result)>;

 public:
  /**
   * Fetch all emoticon sets for the given user.
   */
  ChatGetEmoticonsTask(UserId userId, const std::string& oauthToken, Callback&& callback);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatGetEmoticonsTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  std::vector<EmoticonSet> mResult;
  Callback mCallback;
  UserId mUserId;
};
