/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <vector>

namespace ttv {
namespace chat {
class ChatGetVodCommentsTask;
class ChatEmoticons;
class BitsConfiguration;
}  // namespace chat
}  // namespace ttv

class ttv::chat::ChatGetVodCommentsTask : public ttv::HttpTask {
 public:
  struct Result {
    // Batches are grouped per 250ms.
    struct CommentsBatch {
      std::vector<ChatComment> comments;
      uint64_t baseTimestampMilliseconds;  //!< The timestamp of the first comment in the batch.
    };

    std::vector<CommentsBatch> commentsListBatches;
    std::string nextCursorUrl;
    std::string errorMsg;
  };

  using Callback = std::function<void(ChatGetVodCommentsTask* source, TTV_ErrorCode ec, Result&& result)>;

 public:
  ChatGetVodCommentsTask(const std::string& vodId, const std::string& cursorUrl, const TokenizationOptions& options,
    const std::shared_ptr<BitsConfiguration>& mBitsConfiguration, Callback&& callback);
  ChatGetVodCommentsTask(const std::string& vodId, uint64_t timestampMilliseconds, const TokenizationOptions& options,
    const std::shared_ptr<BitsConfiguration>& mBitsConfiguration, Callback&& callback);
  void SetFetchLimit(uint32_t limit) { mLimit = limit; }

  // Stores the local user's names for properly parsing mentions
  void SetLocalUserNames(const std::vector<std::string>& localUserNames) { mLocalUserNames = localUserNames; }

 protected:
  virtual const char* GetTaskName() const override { return "ChatGetVodCommentsTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ResponseCallback(uint statusCode, const std::vector<char>& response) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  std::string mCursorUrl;
  std::string mVodId;
  uint64_t mTimestampMilliseconds;
  uint32_t mLimit;
  std::shared_ptr<BitsConfiguration> mBitsConfiguration;
  std::vector<std::string> mLocalUserNames;
  TokenizationOptions mTokenizationOptions;
  Result mResult;
  Callback mCallback;
};
