/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/internal/graphql/generated/postchatcommentrequestinfo.h"
#include "twitchsdk/chat/internal/graphql/generated/videocommentsrequestinfo.h"
#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
bool ParseRaidStatusJson(const ttv::json::Value& jRaid, RaidStatus& status);

/**
 * Parses the given json and returns a populated TTV_ChatMessage with dynamically allocated strings.  Be sure to free
 * the string fields.
 */
bool ParseMessageJson(const ttv::json::Value& jMessage, const TokenizationOptions& tokenizationOptions,
  const std::shared_ptr<BitsConfiguration>& bitsConfig, const std::vector<std::string>& localUserNames,
  WhisperMessage& result);
bool ParseChatCommentJson(const ttv::json::Value& jMessage, const TokenizationOptions& tokenizationOptions,
  const std::shared_ptr<BitsConfiguration>& bitsConfig, const std::vector<std::string>& localUserNames,
  ChatComment& result);

template <typename VideoComment, typename VideoCommentState, typename VideoCommentSource>
void ParseChatCommentJsonGQL(const VideoComment& comment, const TokenizationOptions& tokenizationOptions,
  const std::shared_ptr<BitsConfiguration>& bitsConfig, const std::vector<std::string>& localUserNames,
  ChatComment& result, ChannelId channelId = 0, const std::string& videoId = "",
  const std::string& parentCommentId = "");

// Supported templated types
extern template void ttv::chat::ParseChatCommentJsonGQL<ttv::core::graphql::VideoCommentsQueryInfo::VideoComment,
  ttv::core::graphql::VideoCommentsQueryInfo::VideoCommentState,
  ttv::core::graphql::VideoCommentsQueryInfo::VideoCommentSource>(
  const ttv::core::graphql::VideoCommentsQueryInfo::VideoComment&, const TokenizationOptions&,
  const std::shared_ptr<BitsConfiguration>&, const std::vector<std::string>&, ChatComment&, ttv::ChannelId,
  const std::string&, const std::string&);
extern template void
ttv::chat::ParseChatCommentJsonGQL<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoComment,
  ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoCommentState,
  ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoCommentSource>(
  const ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoComment&, const TokenizationOptions&,
  const std::shared_ptr<BitsConfiguration>&, const std::vector<std::string>&, ChatComment&, ttv::ChannelId,
  const std::string&, const std::string&);

bool ParseChannelVodCommentSettingsJson(const ttv::json::Value& jMessage, ChannelVodCommentSettings& result);

/**
 * Parses the GraphQL payloads as json and populates the result with the information.
 */
bool ParseGraphQLErrorCode(const ttv::json::Value& jVal, const std::string& mutationName, GraphQLErrorCode& code);
bool ParseEditRoomMessage(const ttv::json::Value& jVal, ChatRoomMessage& result);
bool ParseSendRoomMessage(const ttv::json::Value& jVal, ChatRoomMessage& result, SendRoomMessageError& error);
bool ParseRoomMessages(const ttv::json::Value& jVal, std::vector<ChatRoomMessage>& result, std::string& resultCursor,
  bool& resultMoreMessages);
bool ParseCreateRoom(const ttv::json::Value& jVal, ChatRoomInfo& result, CreateRoomError& error);
bool ParseUpdateRoom(const ttv::json::Value& jVal, ChatRoomInfo& result, UpdateRoomError& error);
bool ParseUpdateRoomModes(const ttv::json::Value& jVal, ChatRoomInfo& result, UpdateRoomModesError& error);
bool ParseRoomInfo(const ttv::json::Value& jVal, ChatRoomInfo& result);
bool ParseGraphQLChatRooms(const ttv::json::Value& jVal, std::vector<ChatRoomInfo>& result);
bool ParseGraphQLChatRoomView(const ttv::json::Value& jVal, const std::string& mutationName, ChatRoomInfo& result);
bool ParseGraphQLUserMods(const ttv::json::Value& jVal, std::vector<std::string>& result, std::string& cursor);
bool ParseBanUser(const ttv::json::Value& jVal, BanUserError& error);
bool ParseUnbanUser(const ttv::json::Value& jVal, UnbanUserError& error);

bool ParseUserEmoticonSets(const ttv::json::Value& jVal, std::vector<EmoticonSet>& result);
}  // namespace chat
}  // namespace ttv
