/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatModUserTask;
}
}  // namespace ttv

class ttv::chat::ChatModUserTask : public ttv::HttpTask {
 public:
  using ModCallback = std::function<void(ChatModUserTask* source, TTV_ErrorCode ec, ModUserError&& error)>;
  using UnmodCallback = std::function<void(ChatModUserTask* source, TTV_ErrorCode ec, UnmodUserError&& error)>;

  ChatModUserTask(UserId userId, const std::string& modUserName, const std::string& authToken, ModCallback&& callback);
  ChatModUserTask(
    UserId userId, const std::string& modUserName, const std::string& authToken, UnmodCallback&& callback);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatModUserTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  ModCallback mModCallback;
  UnmodCallback mUnmodCallback;
  ModUserError mModError;
  UnmodUserError mUnmodError;
  std::string mModUserName;
  UserId mUserId;
  bool mGrantMod;
};
