/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/internal/task/chatapitask.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"
#include "twitchsdk/core/types/coretypes.h"

namespace ttv {
namespace chat {
class ChatPropertiesTask;
}
}  // namespace ttv

class ttv::chat::ChatPropertiesTask : public ttv::HttpTask {
 public:
  struct Result {
    std::vector<std::string> chat_rules;
    uint32_t chat_delay_duration;
    bool hide_chat_links;

    Result();
  };

  using Callback = std::function<void(ChatPropertiesTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

 public:
  ChatPropertiesTask(ChannelId channelId, Callback callback);

 protected:
  virtual const char* GetTaskName() const override { return "ChatPropertiesTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  ChannelId mChannelId;
  Callback mCallback;
  std::shared_ptr<Result> mResult;
};
