/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <map>

namespace ttv {
namespace chat {
class ChatRaidTask;
}
}  // namespace ttv

class ttv::chat::ChatRaidTask : public ttv::HttpTask {
 public:
  enum class ChangeType { Join, Leave, Start, RaidNow, Cancel, Invalid };

  using Callback = std::function<void(ChatRaidTask* source, TTV_ErrorCode result)>;

 public:
  ChatRaidTask(UserId sourceChannelId, const std::string& authToken, Callback&& callback);

  void Join(const std::string& raidId);
  void Leave(const std::string& raidId);
  void Start(UserId targetChannelId);
  void RaidNow();
  void Cancel(UserId targetChannelId);

 protected:
  virtual const char* GetTaskName() const override { return "ChatRaidTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  Callback mCallback;
  std::string mRaidId;
  ChannelId mSourceChannelId;
  ChannelId mTargetChannelId;
  RaidStatus mResult;
  ChangeType mChangeType;
};
