/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatReportCommentTask;
}
}  // namespace ttv

class ttv::chat::ChatReportCommentTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatReportCommentTask* source, TTV_ErrorCode ec)>;

  ChatReportCommentTask(const std::string& commentId, const std::string& reason, const std::string& description,
    const std::string& authToken, Callback&& callback);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatReportCommentTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;

 private:
  std::string mCommentId;
  std::string mReason;
  std::string mDescription;
  Callback mCallback;
};
