/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatRoomDeleteRoomTask;
}
}  // namespace ttv

class ttv::chat::ChatRoomDeleteRoomTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatRoomDeleteRoomTask* source, TTV_ErrorCode ec)>;

  ChatRoomDeleteRoomTask(const std::string& roomId, const std::string& authToken, Callback&& callback);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatRoomDeleteRoomTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  Callback mCallback;
  std::string mRoomId;
};
