/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatRoomFetchMessagesTask;
}
}  // namespace ttv

class ttv::chat::ChatRoomFetchMessagesTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatRoomFetchMessagesTask* source, TTV_ErrorCode ec,
    std::vector<ChatRoomMessage>&& messages, std::string&& nextCursor, bool moreMessages)>;

  ChatRoomFetchMessagesTask(const std::string& roomId, ChannelId channelId, bool fetchNewer, uint32_t limit,
    const std::string& authToken, Callback&& callback);

  virtual void OnComplete() override;

  virtual void SetCursor(const std::string& cursor);
  virtual void SetTime(Timestamp timestamp);

 protected:
  virtual const char* GetTaskName() const override { return "ChatRoomFetchMessagesTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  std::vector<ChatRoomMessage> mResultMessages;
  Callback mCallback;
  std::string mRoomId;
  std::string mVariableValue;
  std::string mResultCursor;
  ChannelId mChannelId;
  uint32_t mLimit;
  bool mResultMoreMessages;
  bool mFetchAfter;
  bool mUseTimestamp;
};
