/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/json/corejsonutil.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatRoomUpdateViewTask;
}
}  // namespace ttv

class ttv::chat::ChatRoomUpdateViewTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatRoomUpdateViewTask* source, TTV_ErrorCode ec, ChatRoomInfo&& info)>;

  ChatRoomUpdateViewTask(const std::string& roomId, const std::string& authToken, Callback&& callback);

  void SetLastReadAt(Timestamp lastReadAt);
  void SetIsMuted(bool isMuted);
  void SetIsArchived(bool isArchived);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatRoomUpdateViewTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  Callback mCallback;
  ChatRoomInfo mResult;
  std::string mRoomId;
  std::string mVariableKey;
  ttv::json::Value mVariableValue;
};
