/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
namespace chat {
class ChatSetChannelVodCommentSettingsTask;
struct ChannelVodCommentSettings;
}  // namespace chat
}  // namespace ttv

class ttv::chat::ChatSetChannelVodCommentSettingsTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ChatSetChannelVodCommentSettingsTask* source, TTV_ErrorCode ec)>;

  ChatSetChannelVodCommentSettingsTask(ChannelId channelId, CommentPublishingMode mode,
    uint32_t followersOnlyDurationSeconds, const std::string& authToken, Callback&& callback);
  ChatSetChannelVodCommentSettingsTask(
    ChannelId channelId, CommentPublishingMode mode, const std::string& authToken, Callback&& callback);
  ChatSetChannelVodCommentSettingsTask(
    ChannelId channelId, uint32_t followersOnlyDurationSeconds, const std::string& authToken, Callback&& callback);

  virtual void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "ChatSetChannelVodCommentSettingsTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  Callback mCallback;
  ChannelId mChannelId;
  uint32_t mFollowersOnlyDurationSeconds;
  CommentPublishingMode mPublishingMode;
  bool mSetFollowersDuration;
  bool mSetPublishingMode;
};
