/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class ISquadNotifications;
}
}  // namespace ttv

/**
 * The interface to hold onto the ISquadNotificationsListener.
 */
class ttv::chat::ISquadNotifications {
 public:
  virtual ~ISquadNotifications() = default;

  /**
   * This should be called when the application is done with the instance.
   *
   * @return
   *   - TTV_EC_SUCCESS: Instance has been disposed.
   */
  virtual TTV_ErrorCode Dispose() = 0;
};
