/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class ISquadNotificationsListener;
}
}  // namespace ttv

/**
 * Listener interface for unsolicited events for chat rooms on a user level.
 */
class ttv::chat::ISquadNotificationsListener {
 public:
  virtual ~ISquadNotificationsListener() = default;

  virtual void SquadUpdated(SquadInfo&& squad) = 0;
  virtual void SquadEnded() = 0;
};
