/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class ISubscribersListener;
}
}  // namespace ttv

/**
 * The listener interface for events from a SubscribersStatus implementation.
 */
class ttv::chat::ISubscribersListener {
 public:
  virtual ~ISubscribersListener() = default;

  /**
   * Called when a new subscriber event occurs on the associated channel.
   * @param[in]: subscriberAddedEvent The details about the new subscriber event.
   */
  virtual void NewSubscriberAdded(const SubscriberAddedEvent& subscriberAddedEvent) = 0;
};
