/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class ISubscribersStatus;
}
}  // namespace ttv

/**
 * The interface for receiving subscribers updates on a channel.
 */
class ttv::chat::ISubscribersStatus {
 public:
  virtual ~ISubscribersStatus() = default;

  /**
   * This should be called when the application is done with the instance.
   */
  virtual TTV_ErrorCode Dispose() = 0;
};
