/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class ISubscriptionsNotificationsListener;
}
}  // namespace ttv

/**
 * Listener interface for when a user subscribes to a channel.
 */
class ttv::chat::ISubscriptionsNotificationsListener {
 public:
  virtual ~ISubscriptionsNotificationsListener() = default;

  /**
   * Called when the user subscribes to a new channel.
   *
   * @param[in] userId The id of the current user.
   * @param[in] channelId The channel that the user subscribed to.
   */
  virtual void SubscribedToChannel(UserId userId, ChannelId channelId) = 0;
};
