/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/chaterrortypes.h"

ttv::chat::SendRoomMessageError::SendRoomMessageError()
    : code(GraphQLErrorCode::SUCCESS), slowModeDurationSeconds(0), remainingDurationSeconds(0) {}

ttv::chat::CreateRoomError::CreateRoomError()
    : code(GraphQLErrorCode::SUCCESS), maxAllowedRooms(0), minLength(0), maxLength(0) {}

ttv::chat::UpdateRoomError::UpdateRoomError() : code(GraphQLErrorCode::SUCCESS), minLength(0), maxLength(0) {}

ttv::chat::UpdateRoomModesError::UpdateRoomModesError()
    : code(GraphQLErrorCode::SUCCESS), minimumSlowModeDurationSeconds(0), maximumSlowModeDurationSeconds(0) {}

ttv::chat::BanUserError::BanUserError() : code(GraphQLErrorCode::SUCCESS) {}

ttv::chat::UnbanUserError::UnbanUserError() : code(GraphQLErrorCode::SUCCESS) {}

ttv::chat::ModUserError::ModUserError() : code(GraphQLErrorCode::SUCCESS) {}

ttv::chat::UnmodUserError::UnmodUserError() : code(GraphQLErrorCode::SUCCESS) {}
