/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/internal/chaturlgenerator.h"

#include <iomanip>
#include <sstream>

// curl -X GET "https://static-cdn.jtvnw.net/emoticons/v1/$EMOTEID/$SCALE" >> emote.png

namespace {
const char* kEmoticonUrlPrefix = "https://static-cdn.jtvnw.net/emoticons/v1/";
}

TTV_ErrorCode ttv::chat::GetEmoticonUrl(const std::string& emoticonId, float scale, std::string& result) {
  std::ostringstream stream;
  stream << kEmoticonUrlPrefix;
  stream << emoticonId;
  stream << "/";
  stream << std::fixed;
  stream << std::setprecision(1);
  stream << scale;

  result = stream.str();

  return TTV_EC_SUCCESS;
}
