/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/internal/chatuserbadges.h"

#include "twitchsdk/core/user/user.h"

namespace {
const char* kLoggerName = "ChatUserBadges";
}

ttv::chat::ChatUserBadges::ChatUserBadges(const std::shared_ptr<User>& user) : UserComponent(user) {}

std::string ttv::chat::ChatUserBadges::GetLoggerName() const {
  return kLoggerName;
}

std::string ttv::chat::ChatUserBadges::GetBadgesMessageTag(ChannelId channelId) {
  auto iter = mBadges.find(channelId);
  if (iter != mBadges.end()) {
    return iter->second;
  } else {
    return "";
  }
}

void ttv::chat::ChatUserBadges::SetBadgesMessageTag(ChannelId channelId, const std::string& badgesMessageTag) {
  if (badgesMessageTag != "") {
    mBadges[channelId] = badgesMessageTag;
  } else {
    auto iter = mBadges.find(channelId);
    if (iter != mBadges.end()) {
      mBadges.erase(iter);
    }
  }
}
