/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/internal/task/chatdeletecommenttask.h"

#include "twitchsdk/core/httprequestutils.h"
#include "twitchsdk/core/types/coretypes.h"

namespace {
const char* kHostName = "https://api.twitch.tv/kraken/videos/comments/";
const char* kVersion = "application/vnd.twitchtv.v5+json";
}  // namespace

// curl -X DELETE -H 'Accept: application/vnd.twitchtv.v5+json' -H 'Client-ID: $CLIENTID' -H 'Authorization: OAuth
// $OAUTH' "https://api.twitch.tv/kraken/videos/comments/$COMMENTID" | python -m json.tool DELETE
// /v5/videos/comments/:comment_id

ttv::chat::ChatDeleteCommentTask::ChatDeleteCommentTask(
  const std::string& commentId, const std::string& authToken, Callback&& callback)
    : HttpTask(nullptr, nullptr, authToken.c_str()), mCommentId(commentId), mCallback(std::move(callback)) {
  TTV_ASSERT(mCommentId.size() > 0);
  TTV_ASSERT(mCallback);

  ttv::trace::Message(GetTaskName(), MessageLevel::Info, "ChatDeleteCommentTask created");
}

void ttv::chat::ChatDeleteCommentTask::FillHttpRequestInfo(HttpRequestInfo& requestInfo) {
  Uri url;
  url.SetHostName(kHostName);
  url.SetPath(mCommentId);

  requestInfo.requestHeaders.emplace_back("Accept", kVersion);
  requestInfo.url = url.GetUrl();
  requestInfo.httpReqType = HTTP_DELETE_REQUEST;
}

void ttv::chat::ChatDeleteCommentTask::OnComplete() {
  if (mCallback) {
    if (mAborted) {
      mTaskStatus = TTV_EC_REQUEST_ABORTED;
    }
    mCallback(this, mTaskStatus.ec);
  }
}
