/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/internal/task/chatreportcommenttask.h"

#include "twitchsdk/chat/internal/task/chatjson.h"
#include "twitchsdk/core/httprequestutils.h"
#include "twitchsdk/core/json/reader.h"
#include "twitchsdk/core/json/writer.h"
#include "twitchsdk/core/types/coretypes.h"

namespace {
const char* kHostName = "https://api.twitch.tv/kraken/videos/comments/";
const char* kVersion = "application/vnd.twitchtv.v5+json";
}  // namespace

// curl -X POST -H 'Accept: application/vnd.twitchtv.v5+json' -H 'Client-ID: $CLIENTID' -H 'Authorization: OAuth $OAUTH'
// -d 'reason=$REASON&description=$DESCRIPTION' "https://api.twitch.tv/kraken/videos/comments/$COMMENTID/reports" |
// python -m json.tool POST /v5/videos/comments/:comment_id/reports

ttv::chat::ChatReportCommentTask::ChatReportCommentTask(const std::string& commentId, const std::string& reason,
  const std::string& description, const std::string& authToken, Callback&& callback)
    : HttpTask(nullptr, nullptr, authToken.c_str()),
      mCommentId(commentId),
      mReason(reason),
      mDescription(description),
      mCallback(callback) {
  TTV_ASSERT(commentId.size() > 0);
  TTV_ASSERT(mCallback);

  ttv::trace::Message(GetTaskName(), MessageLevel::Info, "ChatReportCommentTask created");
}

void ttv::chat::ChatReportCommentTask::FillHttpRequestInfo(HttpRequestInfo& requestInfo) {
  std::stringstream ss;
  ss << kHostName << mCommentId << "/reports";

  Uri url(ss.str());

  ttv::json::Value root;

  root["reason"] = mReason;

  if (mDescription != "") {
    root["description"] = mDescription;
  }

  ttv::json::FastWriter writer;
  requestInfo.requestBody = writer.write(root);
  requestInfo.requestHeaders.emplace_back("Accept", kVersion);
  requestInfo.requestHeaders.emplace_back("Content-Type", "application/json");
  requestInfo.url = url.GetUrl();
  requestInfo.httpReqType = HTTP_POST_REQUEST;
}

void ttv::chat::ChatReportCommentTask::OnComplete() {
  if (mCallback) {
    if (mAborted) {
      mTaskStatus = TTV_EC_REQUEST_ABORTED;
    }
    mCallback(this, mTaskStatus.ec);
  }
}
