/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "chattestmanager.h"
#include "fixtures/chatbasetest.h"
#include "testtransport.h"
#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/core/coreapi.h"
#include "usertestutility.h"

namespace ttv {
namespace chat {
namespace test {
class ChatApiTest;
}
}  // namespace chat
}  // namespace ttv

class ttv::chat::test::ChatApiTest : public ttv::chat::test::ChatBaseTest {
 public:
  struct TestParams {
    std::string oauth;
    UserInfo userInfo;
    std::string channelName;
    ChannelId channelId;
  };

  TTV_ErrorCode LogIn(const TestParams& testParams);
  TTV_ErrorCode LogOut(const TestParams& testParams);
  TTV_ErrorCode ConnectToChannel(const TestParams& testParams);
  TTV_ErrorCode DisconnectFromChannel(const TestParams& testParams);
  TTV_ErrorCode ShutDown();
  void SendChatMessage(const TestParams& testParams, std::string message);

  /*
   * Chat Api State Test Helpers
   */

  void TestChatApiInitializationCallback(TokenizationOptions tokenizationOption);
  void TestChatApiShutdownCallback();

  /*
   * TestChatChannelStateCallback waits a max of waitUntilMilliSeconds
   * for the channel state to be the same as the expectedState
   * before failing.
   */
  void TestChatChannelStateCallback(
    const TestParams& testParams, ChatChannelState expectedState, uint waitUntilMilliSeconds);

  /*
   * TestIrcHandshake tests the client messages for handshake,
   * responds with server messages to complete the handshake,
   * and sends a join message to the channel being tested.
   */

  void TestIrcHandshake(const TestParams& testParams);

  /*
   * TestClientSentMessage tests if the client sent the expectedMessage
   * and waits a max of waitUntilMilliSeconds before failing.
   */

  void TestClientSentMessage(std::string message, uint waitUntilMilliSeconds);

  /*
   * TestClientSentPrivMessage tests if the client sent
   * an IRC PRIVMSG with the content of 'message' and waits a max
   * of waitUntilMilliSeconds before failing.
   */

  void TestClientSentPrivMessage(const TestParams& testParams, std::string message, uint waitUntilMilliSeconds);
  void TestMessageCallback(const TestParams& testParams, std::vector<MessageInfo> msgList, uint waitUntilMilliSeconds);

 protected:
  ChatApiTest();
  virtual ~ChatApiTest();

  virtual void SetUpStubs() override;
  virtual void SetUpComponents() override;

  virtual void TearDownComponents() override;

  std::string SubstituteMessage(const TestParams& testParams, const std::string& msg);

  std::shared_ptr<ChatTestManager> mChatTestManager;
  std::shared_ptr<ttv::CoreAPI> mCoreApi;
  std::shared_ptr<ttv::chat::ChatAPI> mChatApi;
};
