/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "chattestmanager.h"
#include "fixtures/sdkbasetest.h"
#include "testchatobjectfactory.h"
#include "testtransport.h"

#include "gtest/gtest.h"

namespace ttv {
namespace chat {
namespace test {
class ChatBaseTest;
}
}  // namespace chat
}  // namespace ttv

class ttv::chat::test::ChatBaseTest : public ttv::test::SdkBaseTest {
 protected:
  ChatBaseTest();
  virtual ~ChatBaseTest();

  virtual void SetUpStubs() override;

 protected:
  std::shared_ptr<TestChatObjectFactory> mTestFactory;
  std::shared_ptr<TestTransport> mTransport;

  TTV_ErrorCode GetChatThreadMessages(const std::string& path, std::vector<WhisperMessage>& result);
};
