/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "fixtures/chatbasetest.h"
#include "testtransport.h"
#include "testutilities.h"
#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/core/coreapi.h"

namespace ttv {
namespace chat {
namespace test {
class ChatMessageTest;
}
}  // namespace chat
}  // namespace ttv

class ttv::chat::test::ChatMessageTest : public ChatBaseTest {
 public:
  std::shared_ptr<ChatChannelListenerProxy> mChatChannelListenerProxy;

 protected:
  virtual void SetUpStubs() override;
  virtual void SetUpComponents() override;
  virtual void TearDownComponents() override;

  void SendMessage(const std::string& message);

  std::shared_ptr<ttv::CoreAPI> mCoreApi;
  std::shared_ptr<ttv::chat::ChatAPI> mChatApi;
  std::shared_ptr<TestTransport> mTransport;

  std::map<ChannelId, ChatChannelState> mChannelStates;
};
