/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "fixtures/chatbasetest.h"
#include "testtransport.h"
#include "testutilities.h"
#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/core/coreapi.h"

namespace ttv {
namespace chat {
namespace test {
class ChatStressTest;
}
}  // namespace chat
}  // namespace ttv

class ttv::chat::test::ChatStressTest : public ChatBaseTest,
                                        public virtual ttv::chat::IChatAPIListener,
                                        public virtual ttv::chat::IChatChannelListener {
 public:
  void SetMessageFreeDelay(uint delayMilliseconds) { mMessageFreeDelay = delayMilliseconds; }

  // IModuleListener interface
  virtual void ModuleStateChanged(
    ttv::IModule* /*source*/, ttv::IModule::State /*state*/, TTV_ErrorCode /*ec*/) override {}

  // IChatAPIListener interface
  virtual void ChatUserEmoticonSetsChanged(UserId /*userId*/, const std::vector<EmoticonSet>& /*sets*/) override {}

  // IChatChannelListener interface
  virtual void ChatChannelStateChanged(
    UserId userId, ChannelId channelId, ChatChannelState state, TTV_ErrorCode ec) override;
  virtual void ChatChannelInfoChanged(
    UserId /*userId*/, ChannelId /*channelId*/, const ChatChannelInfo& /*info*/) override {}
  virtual void ChatChannelRestrictionsChanged(
    UserId /*userId*/, ChannelId /*channelId*/, const ChatChannelRestrictions& /*restrictions*/) override {}
  virtual void ChatChannelLocalUserChanged(
    UserId /*userId*/, ChannelId /*channelId*/, const ChatUserInfo& /*userInfo*/) override {}
  virtual void ChatChannelMessagesReceived(
    UserId /*userId*/, ChannelId /*channelId*/, const std::vector<LiveChatMessage>& /*messageList*/) override;
  virtual void ChatChannelSubscriptionNoticeReceived(
    UserId /*userId*/, ChannelId /*channelId*/, const SubscriptionNotice& /*notice*/) override;
  virtual void ChatChannelFirstTimeChatterNoticeReceived(
    UserId /*userId*/, ChannelId /*channelId*/, const FirstTimeChatterNotice& /*notice*/) override;
  virtual void ChatChannelRaidNoticeReceived(
    UserId /*userId*/, ChannelId /*channelId*/, const RaidNotice& /*notice*/) override;
  virtual void ChatChannelUnraidNoticeReceived(UserId userId, ChannelId channelId, const UnraidNotice& notice) override;
  virtual void ChatChannelGenericNoticeReceived(
    UserId userId, ChannelId channelId, const GenericMessageNotice& notice) override;
  virtual void ChatChannelMessagesCleared(UserId /*userId*/, ChannelId /*channelId*/) override {}
  virtual void ChatChannelUserMessagesCleared(
    UserId /*userId*/, ChannelId /*channelId*/, UserId /*clearUserId*/) override {}
  virtual void ChatChannelMessageDeleted(UserId /*userId*/, ChannelId /*channelId*/, std::string&& /*messageId*/,
    std::string&& /*senderLoginName*/, std::string&& /*messageContent*/) override {}
  virtual void ChatChannelModNoticeUserTimedOut(UserId /*userId*/, ChannelId /*channelId*/,
    ModerationActionInfo&& /*modActionInfo*/, uint32_t /*timeoutDurationSeconds*/, std::string&& /*reason*/) override {}
  virtual void ChatChannelModNoticeUserBanned(UserId /*userId*/, ChannelId /*channelId*/,
    ModerationActionInfo&& /*modActionInfo*/, std::string&& /*reason*/) override {}
  virtual void ChatChannelModNoticeUserUntimedOut(
    UserId /*userId*/, ChannelId /*channelId*/, ModerationActionInfo&& /*modActionInfo*/) override {}
  virtual void ChatChannelModNoticeUserUnbanned(
    UserId /*userId*/, ChannelId /*channelId*/, ModerationActionInfo&& /*modActionInfo*/) override {}
  virtual void ChatChannelModNoticeMessageDeleted(UserId /*userId*/, ChannelId /*channelID*/,
    ModerationActionInfo&& /*modActionInfo*/, std::string&& /*messageId*/, std::string&& /*message*/) override {}
  virtual void ChatChannelModNoticeClearChat(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelModNoticeEmoteOnly(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelModNoticeEmoteOnlyOff(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelModNoticeFollowersOnly(ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/,
    ttv::UserId /*modId*/, std::string&& /*modName*/, uint32_t /*minimumFollowingDurationMinutes*/) override {}
  virtual void ChatChannelModNoticeFollowersOnlyOff(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelModNoticeR9K(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelModNoticeR9KOff(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelModNoticeSlow(ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/,
    std::string&& /*modName*/, uint32_t /*slowModeDurationSeconds*/) override {}
  virtual void ChatChannelModNoticeSlowOff(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelModNoticeSubsOnly(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelModNoticeSubsOnlyOff(
    ttv::UserId /*userId*/, ttv::ChannelId /*channelId*/, ttv::UserId /*modId*/, std::string&& /*modName*/) override {}
  virtual void ChatChannelHostTargetChanged(UserId /*userId*/, ChannelId /*channelId*/,
    const std::string& /*targetChannelName*/, uint32_t /*numViewers*/) override {}
  virtual void ChatChannelNoticeReceived(UserId /*userId*/, ChannelId /*channelId*/, const std::string& /*id*/,
    const std::map<std::string, std::string>& /*params*/) override {}
  virtual void AutoModCaughtSentMessage(UserId /*userId*/, ChannelId /*channelId*/) override {}
  virtual void AutoModDeniedSentMessage(UserId /*userId*/, ChannelId /*channelId*/) override {}
  virtual void AutoModApprovedSentMessage(UserId /*userId*/, ChannelId /*channelId*/) override {}
  virtual void AutoModCaughtMessageForMods(UserId /*userId*/, ChannelId /*channelId*/, std::string&& /*messageId*/,
    std::string&& /*message*/, UserId /*senderId*/, std::string&& /*senderName*/, std::string&& /*reason*/) override {}
  virtual void AutoModMessageApprovedByMod(UserId /*userId*/, ChannelId /*channelId*/, std::string&& /*messageId*/,
    UserId /*moderatorId*/, std::string&& /*moderatorName*/) override {}
  virtual void AutoModMessageDeniedByMod(UserId /*userId*/, ChannelId /*channelId*/, std::string&& /*messageId*/,
    UserId /*moderatorId*/, std::string&& /*moderatorName*/) override {}
  virtual void AutoModDeniedSentCheer(UserId /*userId*/, ChannelId /*channelId*/) override {}
  virtual void AutoModTimedOutSentCheer(UserId /*userId*/, ChannelId /*channelId*/) override {}
  virtual void AutoModCaughtCheerForMods(UserId /*userId*/, ChannelId /*channelId*/, std::string&& /*messageId*/,
    std::string&& /*message*/, UserId /*senderId*/, std::string&& /*senderName*/, std::string&& /*reason*/) override {}

 protected:
  ChatStressTest();

  virtual void SetUpStubs() override;
  virtual void SetUpComponents() override;
  virtual void TearDownComponents() override;

  void RunStressTest(uint64_t duration, const std::string& prefix, const std::string& message);

  std::shared_ptr<ttv::CoreAPI> mCoreApi;
  std::shared_ptr<ttv::chat::ChatAPI> mChatApi;
  std::shared_ptr<TestTransport> mTransport;

  std::map<ChannelId, ChatChannelState> mChannelStates;

  std::shared_ptr<ChatStressTest> mThis;
  uint mMessageFreeDelay;
  uint64_t mLastMessageReceivedTime;
  uint32_t mNumMessagesReceived;
  uint32_t mNumMessageBatchesReceived;
};
