/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "fixtures/chatbasetest.h"
#include "twitchsdk/core/task/taskrunner.h"

namespace ttv {
namespace chat {
namespace test {
class ChatTokenizationTest;
}
}  // namespace chat
}  // namespace ttv

class ttv::chat::test::ChatTokenizationTest : public ChatBaseTest {
 public:
  void TestTokenizeLocalMessage(const std::string& message, const std::string& expectedEmotesTag);
  void TestTokenizeServerMessage(const std::string& message, const std::string& emotesMessageTag,
    const std::string& sender, std::vector<std::unique_ptr<MessageToken>>&& expectedTokenList);
  void TestTokenizeServerMessage(const std::string& message, const std::string& emotesMessageTag,
    const std::shared_ptr<BitsConfiguration>& bitsConfig, uint32_t numBits, const std::string& sender,
    std::vector<std::unique_ptr<MessageToken>>&& expectedTokenList);

 protected:
  ChatTokenizationTest();

  virtual void SetUpStubs() override;
  virtual void SetUpComponents() override;

  std::shared_ptr<ChatTestManager> mChatTestManager;

  UserId mTestUserId;
};
