/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "chattestmanager.h"
#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/ichatobjectfactory.h"

#include <string>

namespace ttv {
namespace chat {
namespace test {
class TestChatObjectFactory;
}
}  // namespace chat
}  // namespace ttv

class ttv::chat::test::TestChatObjectFactory : public ttv::chat::IChatObjectFactory {
 public:
  TestChatObjectFactory();
  virtual ~TestChatObjectFactory();

  void SetTransport(std::shared_ptr<ttv::chat::IChatTransport> transport) { mTransport = transport; }

  // IChatObjectFactory implementation
  virtual std::shared_ptr<ttv::chat::IChatTransport> CreateChatTransport() override;

 private:
  std::shared_ptr<ttv::chat::IChatTransport> mTransport;
};
