/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/ichattransport.h"
#include "twitchsdk/core/concurrentqueue.h"

#include <queue>

namespace ttv {
namespace chat {
namespace test {
class TestTransport;
}
}  // namespace chat
}  // namespace ttv

class ttv::chat::test::TestTransport : public ttv::chat::IChatTransport {
 public:
  TestTransport();
  virtual ~TestTransport();

  void SetThreadSafe(bool threadSafe) { mThreadSafe = threadSafe; }

  void EnqueueOutgoingData(const std::string& data);
  std::string NextOutgoingData();
  bool HasOutgoingData() { return mThreadSafe ? !mThreadSafeOutgoingQueue.empty() : !mOutgoingQueue.empty(); }

  void EnqueueIncomingData(const std::string& data);
  std::string NextIncomingData();
  bool HasIncomingData();
  void ClearIncomingData();

  void SetPeristentIncomingData(const std::string& data) { mPersistentIncomingData = data; }

  // IChatTransport implementation
  virtual TTV_ErrorCode Connect(const std::string& uri);
  virtual TTV_ErrorCode Close();
  virtual bool IsOpen();
  virtual void SetReader(std::shared_ptr<ttv::chat::IChatTransportReader> reader);
  virtual TTV_ErrorCode ProcessIncomingEvent(bool& handled);
  virtual TTV_ErrorCode Write(const char* pData, size_t nSize);

 private:
  std::shared_ptr<ttv::chat::IChatTransportReader> mReader;

  ttv::ConcurrentQueue<std::string> mThreadSafeIncomingQueue;
  ttv::ConcurrentQueue<std::string> mThreadSafeOutgoingQueue;
  std::queue<std::string> mIncomingQueue;
  std::queue<std::string> mOutgoingQueue;

  std::string mPersistentIncomingData;
  bool mSocketOpen;
  bool mThreadSafe;
};
