/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/chattokenizationtest.h"
#include "testutilities.h"
#include "twitchsdk/chat/internal/chatconnection.h"
#include "twitchsdk/core/systemclock.h"

using namespace ttv;
using namespace ttv::chat;
using namespace ttv::chat::test;

namespace {
const char* kRawTestChatUrl = "raw://some_url";
}

/**
 * Tests passing a username but a null OAuth token.
 */
TEST_F(ChatBaseTest, ChatConnection_InvalidCtorParams) {
  auto chatObjectFactory = std::make_shared<TestChatObjectFactory>();
  auto chatTransport = std::make_shared<TestTransport>();
  chatObjectFactory->SetTransport(chatTransport);

  auto listenerProxy = std::make_shared<ChatConnectionListenerProxy>();

  UserInfo userInfo;
  userInfo.userId = 9001;
  userInfo.userName = "twitch";

  auto user = std::make_shared<User>(9001);
  user->SetUserInfo(userInfo);

  std::shared_ptr<ChatConnection> chatConnection = std::make_shared<ChatConnection>(1001, user);
  chatConnection->SetListener(listenerProxy.get());
  chatConnection->SetChatObjectFactory(chatObjectFactory);
  chatConnection->SetChannelName("twitch");

  chatConnection->Connect(kRawTestChatUrl);
  chatConnection->Disconnect();
}
