/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/chatapitest.h"
#include "testutilities.h"
#include "twitchsdk/chat/internal/bitsconfigrepository.h"
#include "twitchsdk/core/task/taskrunner.h"

using namespace ttv::chat;
using namespace ttv::chat::test;

const uint32_t kTestTimeoutMilliseconds = 2000;

// TEST_F(ChatBaseTest, BitsConfigRepository) {
//  auto response1 = mHttpRequest->AddResponse("https://gql.twitch.tv/gql")
//                     .SetType(ttv::HTTP_POST_REQUEST)
//                     .SetStatusCode(200)
//                     .SetResponseBodyFromFile("chat/chatfetchchannelcheermotes.json")
//                     .Done();
//  auto response2 = mHttpRequest->AddResponse("https://api.twitch.tv/v5/bits/actions")
//                     .SetResponseBodyFromFile("chat/chatgetbitsconfigtask_global.json")
//                     .Done();
//
//  std::shared_ptr<BitsConfigRepository> bitsConfigRepository = std::make_shared<BitsConfigRepository>();
//  std::shared_ptr<ttv::TaskRunner> taskRunner = std::make_shared<ttv::TaskRunner>();
//  bitsConfigRepository->SetTaskRunner(taskRunner);
//  bitsConfigRepository->Initialize();
//
//  int numFetchedChannel = 0;
//  int numExtraRequests = 0;
//  std::function<void(TTV_ErrorCode ec, const std::shared_ptr<BitsConfiguration>&)> channelCallback =
//    [this, &numFetchedChannel, &numExtraRequests, &response1](
//      TTV_ErrorCode ec, const std::shared_ptr<BitsConfiguration>& config) {
//      ASSERT_TRUE(TTV_SUCCEEDED(ec));
//
//      if (numFetchedChannel == 0) {
//        mHttpRequest->RemoveResponse(response1);
//        mHttpRequest->AddResponse("https://gql.twitch.tv/gql")
//          .SetResponseHandler([&numExtraRequests](const std::string& /*url*/, ttv::HttpRequestType /*type*/,
//                                const std::vector<ttv::HttpParam>& /*headerParams*/, const std::string& /*body*/) {
//            numExtraRequests++;
//            return MockResponse::MockResponseContent();
//          })
//          .Done();
//      }
//
//      numFetchedChannel++;
//
//      ASSERT_EQ(config->GetChannelId(), 1001);
//      ASSERT_EQ(config->GetCheermotes().size(), 29);
//      ASSERT_EQ(config->GetCheermotes()[2].prefix, "lirikCheer");
//    };
//
//  int numFetchedGlobal = 0;
//  std::function<void(TTV_ErrorCode ec, const std::shared_ptr<BitsConfiguration>&)> globalCallback =
//    [this, &numFetchedGlobal, &numExtraRequests, &response2](
//      TTV_ErrorCode ec, const std::shared_ptr<BitsConfiguration>& config) {
//      ASSERT_TRUE(TTV_SUCCEEDED(ec));
//
//      if (numFetchedGlobal == 0) {
//        mHttpRequest->RemoveResponse(response2);
//        mHttpRequest->AddResponse("https://api.twitch.tv/v5/bits/actions")
//          .SetResponseHandler([&numExtraRequests](const std::string& /*url*/, ttv::HttpRequestType /*type*/,
//                                const std::vector<ttv::HttpParam>& /*headerParams*/, const std::string& /*body*/) {
//            numExtraRequests++;
//            return MockResponse::MockResponseContent();
//          })
//          .Done();
//      }
//
//      numFetchedGlobal++;
//
//      ASSERT_EQ(config->GetChannelId(), 0);
//      ASSERT_EQ(config->GetCheermotes().size(), 28);
//      ASSERT_EQ(config->GetCheermotes()[1].prefix, "DoodleCheer");
//    };
//
//  bitsConfigRepository->FetchChannelBitsConfiguration(0, 1001, channelCallback);
//  bitsConfigRepository->FetchGlobalBitsConfiguration(globalCallback);
//  bitsConfigRepository->FetchChannelBitsConfiguration(0, 1001, channelCallback);
//  bitsConfigRepository->FetchGlobalBitsConfiguration(globalCallback);
//
//  WaitUntilResult(kTestTimeoutMilliseconds, [&bitsConfigRepository, &taskRunner, &numFetchedGlobal]() {
//    bitsConfigRepository->Update();
//    taskRunner->PollTasks();
//    return numFetchedGlobal == 2;
//  });
//
//  WaitUntilResult(kTestTimeoutMilliseconds, [&bitsConfigRepository, &taskRunner, &numFetchedChannel]() {
//    bitsConfigRepository->Update();
//    taskRunner->PollTasks();
//    return numFetchedChannel == 2;
//  });
//
//  bitsConfigRepository->FetchGlobalBitsConfiguration(globalCallback);
//  bitsConfigRepository->FetchChannelBitsConfiguration(0, 1001, channelCallback);
//  bitsConfigRepository->FetchChannelBitsConfiguration(0, 0, globalCallback);
//
//  bitsConfigRepository->Update();
//  taskRunner->PollTasks();
//
//  WaitUntilResult(kTestTimeoutMilliseconds,
//    [&numFetchedGlobal, &numFetchedChannel]() { return (numFetchedGlobal == 4) && (numFetchedChannel == 3); });
//
//  if (bitsConfigRepository->GetState() == BitsConfigRepository::State::Initialized) {
//    bitsConfigRepository->Shutdown();
//  }
//
//  std::function<void()> updateFunc = [&bitsConfigRepository]() { bitsConfigRepository->Update(); };
//
//  ASSERT_TRUE(ttv::test::WaitUntilResultWithPollTask(kTestTimeoutMilliseconds,
//    [&bitsConfigRepository]() {
//      return bitsConfigRepository->GetState() == BitsConfigRepository::State::Uninitialized;
//    },
//    updateFunc));
//
//  ttv::test::ShutdownTaskRunner(taskRunner);
//
//  ASSERT_EQ(numFetchedGlobal, 4);
//  ASSERT_EQ(numFetchedChannel, 3);
//  ASSERT_EQ(numExtraRequests, 0);
//}

TEST_F(ChatBaseTest, ChannelRepository) {
  // TODO: Unit tests: ttv::ChannelRepository - https://twitchtv.atlassian.net/browse/SDK-52
}
