/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/chatstresstest.h"
#include "testchatobjectfactory.h"
#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/ichatobjectfactory.h"
#include "twitchsdk/core/systemclock.h"
#include "twitchsdk/core/thread.h"

#include <sstream>

#include "gtest/gtest.h"

using namespace ttv;
using namespace ttv::chat::test;

namespace {
const uint64_t kTestDuration = 5;
}

// Don't run these stress tests in debug since the metrics aren't useful
#if 1  //!_DEBUG

TEST_F(ChatStressTest, HighMessageVolume_ShortSimpleMessages) {
  // Generate the message
  uint32_t messageLengthInBytes = 180;

  std::string prefix =
    "@color=#5F9EA0;display-name=twitch;emotes=;subscriber=0;turbo=1;user-type=mod :twitch!twitch@twitch.tmi.twitch.tv PRIVMSG #pokemon :";
  std::string message = std::string(messageLengthInBytes, 'A');

  RunStressTest(kTestDuration, prefix, message);
}

TEST_F(ChatStressTest, HighMessageVolume_LongSimpleMessages) {
  // Generate the message
  uint32_t messageLengthInBytes = ttv::chat::IChatTransport::kMaxIrcTextLength;

  std::string prefix =
    "@color=#5F9EA0;display-name=twitch;emotes=;subscriber=0;turbo=1;user-type=mod :twitch!twitch@twitch.tmi.twitch.tv PRIVMSG #pokemon :";
  std::string message = std::string(messageLengthInBytes, 'A');

  RunStressTest(kTestDuration, prefix, message);
}

TEST_F(ChatStressTest, HighMessageVolume_ShortComplexMessages) {
  // Generate the message
  uint32_t messageLengthInBytes = 240;
  std::string prefix =
    "@color=#5F9EA0;display-name=twitch;emotes=;subscriber=0;turbo=1;user-type=mod :twitch!twitch@twitch.tmi.twitch.tv PRIVMSG #pokemon :";
  std::string chunk = "Hello Kappa www.twitch.tv @dude :) :( ";

  std::string message;

  while (message.size() + chunk.size() < messageLengthInBytes) {
    message += chunk;
  }

  RunStressTest(kTestDuration, prefix, message);
}

TEST_F(ChatStressTest, HighMessageVolume_LongComplexMessages) {
  // Generate the message
  uint32_t messageLengthInBytes = ttv::chat::IChatTransport::kMaxIrcTextLength;
  std::string prefix =
    "@color=#5F9EA0;display-name=twitch;emotes=;subscriber=0;turbo=1;user-type=mod :twitch!twitch@twitch.tmi.twitch.tv PRIVMSG #pokemon :";
  std::string chunk = "Hello Kappa www.twitch.tv @dude :) :( ";

  std::string message;

  while (message.size() + chunk.size() < messageLengthInBytes) {
    message += chunk;
  }

  RunStressTest(kTestDuration, prefix, message);
}

TEST_F(ChatStressTest, HighMessageVolume_EmotesOnly) {
  // Generate the message
  uint32_t messageLengthInBytes = ttv::chat::IChatTransport::kMaxIrcTextLength;
  std::string chunk = "A";

  std::stringstream prefix;
  prefix << "@color=#5F9EA0;display-name=twitch;subscriber=0;turbo=1;user-type=mod;emotes=";

  for (int i = 0; i < 100; ++i) {
    if (i > 0) {
      prefix << '/';
    }

    prefix << (i + 1) << ':' << (i * 3) << '-' << (i * 3 + 1);
  }

  prefix << " :twitch!twitch@twitch.tmi.twitch.tv PRIVMSG #pokemon :";

  std::string message;

  while (message.size() + chunk.size() < messageLengthInBytes) {
    message += chunk;
  }

  RunStressTest(kTestDuration, prefix.str(), message);
}

#endif
