/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/chatapitest.h"
#include "fixtures/sdkbasetest.h"
#include "testutilities.h"
#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/isubscriptionsnotificationslistener.h"
#include "twitchsdk/core/coreapi.h"
#include "twitchsdk/core/stringutilities.h"

using namespace ttv;
using namespace ttv::chat;
using namespace ttv::test;
using namespace ttv::chat::test;

namespace {
class TestSubscriptionsNotificationsListener : public ttv::chat::ISubscriptionsNotificationsListener {
 public:
  using NewSubscriptionCallback = std::function<void(UserId userId, ChannelId channelId)>;

  virtual void SubscribedToChannel(UserId userId, ChannelId channelId) override {
    if (newSubscriptionsCallback != nullptr) {
      newSubscriptionsCallback(userId, channelId);
    }
  }

  NewSubscriptionCallback newSubscriptionsCallback;
};

class SubscriptionNotificationsTest : public SdkBaseTest {
 public:
  virtual void SetUpComponents() override {
    SdkBaseTest::SetUpComponents();

    mCoreApi = std::make_shared<CoreAPI>();
    mChatApi = std::make_shared<ChatAPI>();

    mChatApi->SetCoreApi(mCoreApi);
    mChatApi->SetTokenizationOptions(TokenizationOptions::All());

    InitializeModule(mCoreApi);
    InitializeModule(mChatApi);

    AddModule(mCoreApi);
    AddModule(mChatApi);

    mUserInfo.userId = 12345;
    mUserInfo.userName = "subber";
    mUserInfo.displayName = "subber";

    TTV_ErrorCode ec = LogIn(mCoreApi, "auth_token", mUserInfo);
    ASSERT_TRUE(TTV_SUCCEEDED(ec));

    mSubscriptionsListener = std::make_shared<TestSubscriptionsNotificationsListener>();
  }

 protected:
  UserInfo mUserInfo;
  std::shared_ptr<TestSubscriptionsNotificationsListener> mSubscriptionsListener;
  std::shared_ptr<ChatAPI> mChatApi;

 private:
  std::shared_ptr<CoreAPI> mCoreApi;
};
}  // namespace

TEST_F(SubscriptionNotificationsTest, NewSubscription) {
  bool receivedCallback = false;
  mSubscriptionsListener->newSubscriptionsCallback = [&receivedCallback](UserId userId, ChannelId channelId) {
    ASSERT_EQ(userId, 12345);
    ASSERT_EQ(channelId, 6789);
    receivedCallback = true;
  };

  std::shared_ptr<ISubscriptionsNotifications> subscriptionsNotifications;
  auto result = mChatApi->CreateSubscriptionsNotifications(12345, mSubscriptionsListener);
  ASSERT_TRUE(result.IsSuccess());

  ASSERT_TRUE(WaitUntilResultWithPollTask(1000,
    [this]() { return mPubSubTestUtility.IsSubscribedToTopic("user-subscribe-events-v1.12345"); },
    GetDefaultUpdateFunc()));

  mPubSubTestUtility.PushPubSubMessage(
    "user-subscribe-events-v1.12345", "{\"user_id\":\"12345\",\"channel_id\":\"6789\"}");

  ASSERT_TRUE(
    WaitUntilResultWithPollTask(1000, [&receivedCallback]() { return receivedCallback; }, GetDefaultUpdateFunc()));
}
