package tv.twitch.chat;

import tv.twitch.CoreErrorCode;
import tv.twitch.ErrorCode;
import tv.twitch.NativeProxy;
import tv.twitch.PassThroughJniThreadValidator;

public class ChannelChatRoomManagerProxy extends NativeProxy implements IChannelChatRoomManager {
    // SDK-755 AND-9927 this code should be deleted. It hasn't been audited for thread safety
    private native ErrorCode AddNewChatRoom(long nativeObjectPointer, String roomName, String topic,
        RoomRolePermissions permissions, AddRoomCallback callback);
    private native ErrorCode JoinChatRooms(long nativeObjectPointer, JoinCallback callback);
    private native ErrorCode LeaveChatRooms(long nativeObjectPointer, LeaveCallback callback);
    private native ErrorCode FetchChatRoomsInfo(long nativeObjectPointer, FetchRoomsInfoCallback callback);
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public ChannelChatRoomManagerProxy(long nativeObjectPointer) {
        // SDK-755 AND-9927 this code should be deleted. It hasn't been audited for thread safety
        super(nativeObjectPointer, PassThroughJniThreadValidator.INSTANCE);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // SDK-755 AND-9927 this code should be deleted. It hasn't been audited for thread safety
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public ErrorCode addNewChatRoom(
        String roomName, String topic, RoomRolePermissions permissions, AddRoomCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return AddNewChatRoom(ptr, roomName, topic, permissions, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode joinChatRooms(JoinCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return JoinChatRooms(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode leaveChatRooms(LeaveCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return LeaveChatRooms(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode fetchChatRoomsInfo(FetchRoomsInfoCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return FetchChatRoomsInfo(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }
}
