package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ChatBadgeAction {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    None(0),
    Subscribe(1),
    VisitUrl(2),
    GetTurbo(3),
    GetBits(4);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, ChatBadgeAction> s_Map = new HashMap<Integer, ChatBadgeAction>();

    static {
        EnumSet<ChatBadgeAction> set = EnumSet.allOf(ChatBadgeAction.class);

        for (ChatBadgeAction e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ChatBadgeAction lookupValue(int val) {
        ChatBadgeAction err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private ChatBadgeAction(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
