package tv.twitch.chat;

import tv.twitch.NativeProxy;
import tv.twitch.PassThroughJniThreadValidator;

public class ChatChannelPropertiesProxy extends NativeProxy implements IChatChannelProperties {
    // AND-9927 Disposing a ChatChannelPropertiesProxy is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public ChatChannelPropertiesProxy(long nativeObjectPointer) {
        // AND-9927 Disposing a ChatChannelPropertiesProxy is safe from any thread
        super(nativeObjectPointer, PassThroughJniThreadValidator.INSTANCE);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a ChatChannelPropertiesProxy is safe from any thread
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}
