package tv.twitch.chat;

import tv.twitch.ErrorCode;
import tv.twitch.IJniCallable;
import tv.twitch.IJniThreadValidator;
import tv.twitch.NativeProxy;

public class ChatChannelProxy extends NativeProxy implements IChatChannel {
    private native ErrorCode Connect(long nativeObjectPointer);
    private native ErrorCode Disconnect(long nativeObjectPointer);
    private native ErrorCode SendMessage(long nativeObjectPointer, String message);
    // AND-9927 Disposing a ChatChannelProxy is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public ChatChannelProxy(long nativeObjectPointer, IJniThreadValidator jniThreadValidator) {
        super(nativeObjectPointer, jniThreadValidator);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public ErrorCode connect() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Connect(getNativeObjectPointer());
            }
        });
    }

    @Override
    public ErrorCode disconnect() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Disconnect(getNativeObjectPointer());
            }
        });
    }

    @Override
    public ErrorCode sendMessage(final String message) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SendMessage(getNativeObjectPointer(), message);
            }
        });
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a ChatChannelProxy is safe from any thread
        DisposeNativeInstance(getNativeObjectPointer());
    }
}
