package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/**
 * The current state of the chat connection.
 */
public enum ChatChannelState {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Disconnected(0),
    Connecting(1),
    Connected(2),
    Disconnecting(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, ChatChannelState> s_Map = new HashMap<Integer, ChatChannelState>();

    static {
        EnumSet<ChatChannelState> set = EnumSet.allOf(ChatChannelState.class);

        for (ChatChannelState e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ChatChannelState lookupValue(int val) {
        ChatChannelState err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private ChatChannelState(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
